package gov.va.med.mhv.usermgmt.service.adapter;

import java.util.Hashtable;
import java.util.Properties;

import javax.naming.Context;
import javax.naming.directory.SearchControls;

import org.tigris.atlas.config.ConfigurationManager;

public class ActiveDirectoryEnvironment {	
	private static Properties PROPS = null;
	private static Hashtable<String,String> LDAP_ENVIRONMENT = null; 
	private static SearchControls SEARCH_CONTROLS = null;
	
	private static final String PROP_FILE = "/active_directory.properties";
	private static final String URL = "url";
	private static final String ADMIN_PRINCIPAL = "adminPrincipal";
	private static final String ADMIN_PASSWORD = "adminPassword";
	private static final String SEARCH_BASE = "searchBase";
		
	//setup as singleton
	private static ActiveDirectoryEnvironment INSTANCE;
	private ActiveDirectoryEnvironment() {}		
	private static ActiveDirectoryEnvironment getInstance() {
		return INSTANCE;
	}
	
	//1 time init of these variables
	static{
		INSTANCE = new ActiveDirectoryEnvironment();
		PROPS = ConfigurationManager.getConfiguration( PROP_FILE );
		SEARCH_CONTROLS = new SearchControls();
		SEARCH_CONTROLS.setReturningAttributes(new String[]{"sAMAccountName","cn","givenName","sn","title","physicalDeliveryOfficeName","department","company","telephoneNumber","mail"}); //Specify the attributes to return
		SEARCH_CONTROLS.setSearchScope(SearchControls.SUBTREE_SCOPE);
		LDAP_ENVIRONMENT = new Hashtable<String,String>();
		LDAP_ENVIRONMENT.put(Context.INITIAL_CONTEXT_FACTORY,"com.sun.jndi.ldap.LdapCtxFactory");
		LDAP_ENVIRONMENT.put(Context.SECURITY_AUTHENTICATION,"simple");
		LDAP_ENVIRONMENT.put(Context.SECURITY_PRINCIPAL,getAdminPrincipal());
		LDAP_ENVIRONMENT.put(Context.SECURITY_CREDENTIALS,getAdminPassword());
		LDAP_ENVIRONMENT.put(Context.PROVIDER_URL,getUrl());
	}
	
	private Properties getProperties() {
		return PROPS;
	}
	
	public static SearchControls getSearchControls(){
		return SEARCH_CONTROLS;
	}
	
	public static Hashtable getLdapEnvironment(){
		return LDAP_ENVIRONMENT;
	}
	
	public static String getUrl() {
		return (String) getInstance().getProperties().getProperty( URL );
	}
	
	public static String getAdminPrincipal() {
		return (String) getInstance().getProperties().getProperty( ADMIN_PRINCIPAL );
	}
	
	public static String getAdminPassword() {
		return (String) getInstance().getProperties().getProperty( ADMIN_PASSWORD );
	}
	
	public static String getSearchBase() {
		return (String) getInstance().getProperties().getProperty( SEARCH_BASE );
	}
}
